% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_check.R
\name{name_check}
\alias{name_check}
\title{Name Check}
\usage{
name_check(DD.dict, DS.data, verbose = TRUE)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{verbose}{When TRUE, the function prints the Message out, as well as a list of the non-matching variable names.}
}
\value{
Tibble, returned invisibly, containing: (1) Time (time stamp); (2) Name (name of the function); (3) Status (Passed/Failed); (4) Message (A copy of the message the function printed out); (5) Information (Names of variables that mismatch between the data and data dictionary).
}
\description{
This function checks if the variable names match between the data dictionary and the data.
}
\examples{
# Example 1: Fail check (name mismatch)
data(ExampleM)
name_check(DD.dict.M, DS.data.M)
DS.data_updated <- name_correct(DD.dict.M, DS.data.M)
name_check(DD.dict.M, DS.data_updated)

# Example 2: Pass check
data(ExampleA)
name_check(DD.dict.A, DS.data.A)
print(name_check(DD.dict.A, DS.data.A, verbose=FALSE))
}
\seealso{
\code{\link{name_correct}}

\code{\link{reorder_dictionary}}

\code{\link{reorder_data}}
}
