% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcsp.R
\name{predict.dbcsp}
\alias{predict.dbcsp}
\title{Predict function implemented by dbcsp class}
\usage{
\method{predict}{dbcsp}(object, X_test, true_targets=NULL, ...)
}
\arguments{
\item{object}{object of class \code{\link[=dbcsp-class]{dbcsp}}.}

\item{X_test}{list of matrices for test data.}

\item{true_targets}{vector of true labels of the instances. Note that they must match the names of the labels used when training the model.}

\item{...}{not currently used.}
}
\value{
The values returned by the LDA \code{\link[MASS]{predict.lda}} function, a list with these components:
\itemize{
\item \code{class} The MAP classification (a factor)
\item \code{posterior} Posterior probabilities for the classes
\item \code{x} The scores of test cases on up to dimen discriminant variables
}

If the \code{true_targets} are indicated, two more items are added to the output list:
\itemize{
\item \code{confusion_matrix} The confusion matrix obtained with predicted labels and true labels.
\item \code{acc} The accuracy value obtained for the test instances.
}
}
\description{
This function returns the labels predicted for the input instances. If \code{true_targets} are passed as parameter,
the accuracy obtained is printed too.
}
\details{
It gives the predictions for the test data using the model saved in the object, which has been previously trained with
the \code{\link{train.dbcsp}} function. If the \code{true_targets} are indicated, the confusion matrix and obtained accuracy value are
returned too.
}
\examples{
# Read data from 2 classes
x <- AR.data$come[1:20]
y <- AR.data$five[1:20]
mydbcsp <- new("dbcsp", X1 = x, X2 = y)
mydbcsp <- train(mydbcsp,fold=3)
test_data <- c(AR.data$come[20:24], AR.data$five[20:24])
test_labels <- c(rep('x',5),rep('y',5))
predictions <- predict(mydbcsp,test_data,test_labels)
# Predicted classes
print(predictions$class)
# Confusion matrix
print(predictions$confusion_matrix)
# Accuracy
print(predictions$acc)
}
\seealso{
\code{\link[=dbcsp-class]{dbcsp}}, \code{\link[=print.dbcsp]{print}}, \code{\link[=summary.dbcsp]{summary}}, \code{\link[=train.dbcsp]{train}}, \code{\link{selectQ}}, \code{\link[=plot.dbcsp]{plot}}, \code{\link[=boxplot.dbcsp]{boxplot}}
}
