% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_mixed.R
\name{dist_mixed}
\alias{dist_mixed}
\title{Compute Gower dissimilarity for mixed-type data}
\usage{
dist_mixed(
  x,
  continuous_cols = NULL,
  binary_cols = NULL,
  categorical_cols = NULL,
  binary_asym = FALSE
)
}
\arguments{
\item{x}{A data frame with rows as observations and columns as variables.}

\item{continuous_cols}{Optional numeric indices or column names for continuous variables.}

\item{binary_cols}{Optional numeric indices or column names for binary variables.}

\item{categorical_cols}{Optional numeric indices or column names for categorical/multiclass variables.}

\item{binary_asym}{Logical; if TRUE, binary variables are treated as asymmetric (only 1/1 counts as match).}
}
\value{
A symmetric numeric matrix of pairwise dissimilarities in [0,1].
}
\description{
Internal helper function to compute pairwise dissimilarities for datasets
containing a mix of continuous, binary, and categorical variables using
Gower's method \insertCite{gower1971general}{dbrobust}.
}
\details{
Continuous, binary, and categorical columns can be automatically detected,
or explicitly specified by the user via \code{continuous_cols}, \code{binary_cols},
and \code{categorical_cols}.


\itemize{
 \item Continuous, binary, and categorical columns are combined into a single dissimilarity
  measure following Gower's approach.
 \item Continuous variables are scaled by their range.
 \item Binary variables can be treated as symmetric (0/0 and 1/1 count as match)
  or asymmetric (only 1/1 counts as match).
 \item Categorical variables are compared using simple matching.
 \item Missing values are ignored pairwise.
}

\strong{Advantages:}
\itemize{
  \item Low computational cost.
  \item Works naturally with mixed-type data.
}

\strong{Limitations:}
\itemize{
  \item Neglects potential correlations among quantitative variables.
  \item Sensitive to outliers, which can affect robustness.
  \item May overemphasize categorical differences in mixed-data settings.
}
}
\examples{
# Small example: Compute classical Gower for a simulated data frame
df <- data.frame(
  height = c(170, 160, 180),
  gender = factor(c("M", "F", "M")),
  smoker = c(1, 0, 1)
)

# Compute Gower dissimilarities automatically detecting types
dbrobust::dist_mixed(df)

# Manual type specification
cont_cols <- "height"
cat_cols <- NULL
bin_cols <- c("gender","smoker")
dbrobust::dist_mixed(
  x = df,
  continuous_cols = cont_cols,
  categorical_cols = cat_cols,
  binary_cols = bin_cols
)

}
\references{
\insertRef{gower1971general}{dbrobust}
}
\keyword{internal}
