% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_dci.R
\name{calculate_dci_dia}
\alias{calculate_dci_dia}
\title{Calculate non-thresholded diadromous DCI}
\usage{
calculate_dci_dia(
  all_members,
  net_nodes,
  seg_weights,
  outlet_seg,
  parallel,
  quiet
)
}
\arguments{
\item{all_members}{An integer vector holding all assigned membership labels
in the \code{\link{river_net}} object.}

\item{net_nodes}{An \code{sf} object of the nodes of the
\code{\link{river_net}}
object with river attributes joined.}

\item{seg_weights}{A data frame of each segments total length. Either
weighted or unweighted depending on parameters.}

\item{outlet_seg}{An integer indicating the membership label of the outlet
segment}

\item{parallel}{Logical. If \code{FALSE}, the default, all operations are
performed in series. If \code{TRUE} parallel operation is performed using
\code{\link[furrr:future_map2]{furrr::future_pmap()}}. Specify the number of workers and strategy using
\code{\link[future:plan]{future::plan()}}.}

\item{quiet}{Logical. If \code{FALSE}, prints the global DCI and a plot of river
segments to the console. Defaults to \code{TRUE}.}
}
\value{
A data frame which holds raw and relative DCI scores for each
segment.
}
\description{
Calculate non-thresholded diadromous DCI
}
\keyword{internal}
