% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import_points}
\alias{import_points}
\title{Prepare point data for connectivity analyses}
\usage{
import_points(pts, type)
}
\arguments{
\item{pts}{A character string specifying the path to a shapefile of points,
or an \code{sf} object containing point features.}

\item{type}{A character string indicating the type of points. Must be one of:
\code{"bars"} for barriers or \code{"out"} for the outlet.}
}
\value{
An object of class \code{barriers} or \code{outlet} depending on \code{type},
prepared for use with \code{\link[=river_net]{river_net()}}.
}
\description{
Reads and prepares geospatial point data for use with \code{\link[=river_net]{river_net()}}.
}
\examples{
import_points(yamaska_barriers, type = "bars")
import_points(yamaska_outlet, type = "out")
}
