% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfl_decompose.R
\name{dfl_decompose_bootstrap}
\alias{dfl_decompose_bootstrap}
\title{Bootstrapping the DFL reweighting decomposition}
\usage{
dfl_decompose_bootstrap(
  formula,
  dep_var,
  data_used,
  weights,
  group_variable,
  reference_group,
  estimate_statistics,
  statistics,
  probs,
  custom_statistic_function,
  right_to_left,
  trimming,
  trimming_threshold,
  ...
)
}
\arguments{
\item{formula}{\code{formula} object}

\item{dep_var}{dependent variable}

\item{data_used}{\code{data.frame} with data used for estimation}

\item{weights}{weights variable}

\item{group_variable}{group variable}

\item{reference_group}{reference_group to be reweighted}

\item{estimate_statistics}{boolean: if \code{TRUE} (default), then distributional
statistics are estimated and the decomposition is performed. If \code{FALSE},
the function only returns the fitted inverse propensity weights.}

\item{statistics}{a character vector that defines the distributional statistics
for which the decomposition is performed.}

\item{probs}{a vector of length 1 or more with the probabilities of the quantiles
to be estimated.}

\item{custom_statistic_function}{a function estimating a custom distributional statistic
that will be decomposed.}

\item{right_to_left}{determines the direction of a sequential decomposition.}

\item{trimming}{boolean: If \code{TRUE}, observations with dominant reweighting factor
values are trimmed according to rule of Huber, Lechner, and Wunsch (2013).}

\item{trimming_threshold}{numeric: threshold defining the maximal accepted
relative weight of the reweighting factor value (i.e., inverse probability weight)
of a single observation. If \code{NULL}, the threshold is set to \eqn{sqrt(N)/N},
where \eqn{N} is the number of observations in the reference group.}

\item{...}{other parameters passed to the function estimating the conditional probabilities.}
}
\description{
The function resamples observations and restimates the DFL decomposition
with the new sample.
}
