% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{valid}
\alias{valid}
\title{Validity and Reliability check.}
\usage{
valid(data, alpha = 0.05, total = NULL)
}
\arguments{
\item{data}{A data set/ matrix  (\emph{see} \strong{Details}).}

\item{alpha}{An alpha value (\emph{see} \strong{Details}).}

\item{total}{A single numeric value of the index column (\emph{see} \strong{Details}).}
}
\value{
Function returns a data frame with \emph{k} row and four columns.
the columns indicate the item-rest correlation, correlation threshold,
p value, and validity and reliability conclusion.
}
\description{
This function calculates the item-rest correlation.
}
\details{
The data set is a data frame/ matrix \emph{n x k}. The row is
the name of the respondent as many as \emph{n}, while the column is 
the variables (\emph{k}). The alpha value is set between 0.0001 and 
0.20, the default is 0.05. If the \code{total} input is \code{NULL},
it means that the total score will be calculated first, 
the column index of the total score can be also stated otherwise.
The index of the column is a numeric value with a length of one.
It has to be between 1 and (\emph{k}).
}
\examples{
#data simulation of 10 person 5 variables
set.seed(1)
dat <- matrix(sample(1:7,10*5, replace = TRUE), 10,5)
valid(dat)

}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
