% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_glossaries2.R
\name{list_glossaries2}
\alias{list_glossaries2}
\title{List All Glossaries from the DeepL API Free}
\usage{
list_glossaries2(auth_key)
}
\arguments{
\item{auth_key}{A string representing the authentication key for the DeepL API Free. 
If not provided, the function will attempt to retrieve the key from the environment 
variable \code{DEEPL_API_KEY}. You can set this variable using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} 
file for persistent use.}
}
\description{
\code{list_glossaries2} retrieves a list of all glossaries and their metadata associated with your DeepL API Free account. 
Note that glossary entries themselves are not included.
}
\details{
To use this function, you must obtain an authentication key by registering for a DeepL API Free account at 
    \href{https://www.deepl.com/pro#developer}{DeepL API Free}.
}
\examples{
\dontrun{
list_glossaries2()
}

}
\references{
\href{https://developers.deepl.com/docs/api-reference/glossaries#list-all-glossaries}{DeepL API Documentation on Glossaries}
}
