% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate2.R
\name{translate2}
\alias{translate2}
\title{Translate Texts Using the DeepL API Free}
\usage{
translate2(
  text,
  target_lang = "EN",
  source_lang = NULL,
  split_sentences = TRUE,
  preserve_formatting = FALSE,
  get_detect = FALSE,
  context = NULL,
  model_type = NULL,
  formality = NULL,
  glossary_id = NULL,
  auth_key
)
}
\arguments{
\item{text}{Character vector. The text(s) to translate. Each element can contain multiple sentences 
but must not exceed 30 kB. Only UTF-8 plain text is supported.}

\item{target_lang}{Character vector. Target language(s) for translation. If length 1, all texts are 
translated into the same language.}

\item{source_lang}{Character vector or \code{NULL}. Source language(s). If \code{NULL}, the language 
is auto-detected. If of length 1, it is applied to all texts.}

\item{split_sentences}{Logical. If \code{TRUE} (default), DeepL splits input into sentences before 
translating. Set to \code{FALSE} to avoid unintended splits in short texts.}

\item{preserve_formatting}{Logical. If \code{TRUE}, preserves some text formatting (e.g., punctuation and capitalization).}

\item{get_detect}{Logical. If \code{TRUE}, returns a tibble including detected source languages along 
with translations.}

\item{context}{Optional. Contextual text to improve translation quality, especially for short or ambiguous inputs. 
Context is not translated and does not count toward character limits.}

\item{model_type}{Optional. Specifies the DeepL model to use:
\itemize{
  \item \code{"latency_optimized"} – Default low-latency model.
  \item \code{"quality_optimized"} – Higher-quality, higher-latency model (Pro only, limited languages).
  \item \code{"prefer_quality_optimized"} – Uses quality-optimized when available; otherwise falls back.
}}

\item{formality}{Optional. Controls the formality level of the translation (only supported for certain target languages):
\itemize{
  \item \code{"default"} – Neutral.
  \item \code{"more"} – More formal.
  \item \code{"less"} – More informal.
  \item \code{"prefer_more"} – Prefer formal, fallback to default.
  \item \code{"prefer_less"} – Prefer informal, fallback to default.
}}

\item{glossary_id}{Optional. Glossary ID for translation. Must match the language pair and requires \code{source_lang}.
Use \code{\link{list_glossaries2}} to retrieve IDs.}

\item{auth_key}{Character. Your DeepL API authentication key. If missing, the function uses 
the \code{DEEPL_API_KEY} environment variable. You can set it using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or in your \code{.Renviron} file.}
}
\value{
If \code{get_detect = FALSE}, returns a character vector of translated texts.  
If \code{get_detect = TRUE}, returns a tibble with:
\itemize{
  \item \code{translation} – Translated text.
  \item \code{source_lang} – Detected or provided source language.
}
}
\description{
Translates UTF-8 encoded plain text between supported languages using the DeepL API Free. 
A list of supported source and target languages is available at 
\url{https://developers.deepl.com/docs/getting-started/supported-languages}. 
An authentication key is required. The Free plan allows up to 500,000 characters per month.
}
\details{
Register for a free DeepL API key at \url{https://www.deepl.com/pro#developer}. 
Only texts passed via the \code{text} argument count toward your monthly character quota.
}
\examples{
\dontrun{
translate2("I like to translate texts.", target_lang = "DE")

translate2(
  c("I like to translate texts.", "Ich übersetze gerne Texte."), 
  target_lang = "FR"
  )

translate2("I like to translate texts.", target_lang = c("FR", "DE", "IT"))

translate2(
  c("I like to translate texts.", "Ich übersetze gerne Texte."), 
  target_lang = c("FR", "IT")
  )
}

}
\references{
\href{https://developers.deepl.com/docs/api-reference/translate}{DeepL API Documentation — Translate}
}
\seealso{
\code{\link{list_glossaries2}}
}
