% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_degross_print.R
\name{print.degross}
\alias{print.degross}
\title{Print a 'degross' object.}
\usage{
\method{print}{degross}(x, ...)
}
\arguments{
\item{x}{A \link{degross.object} generated by \link{degross}.}

\item{...}{Possible additional printing options.}
}
\value{
Print information on the fitted density corresponding to the \link{degross.object} \code{x}: the estimated central moments within each class (or big bin) are printed with global fit statistics. A summary of the observed data is also provided: it includes the total sample size, the numbers of small and big bins with their limits in addition to the number of B-splines used for density estimation with \code{\link{degross}}.
}
\description{
Print a summary of the information contained in a \link{degross.object} generated by \code{\link{degross}} for density estimation from tabulated frequency and central moment data.
}
\examples{
sim = simDegrossData(n=3500, plotting=TRUE)
obj.data = degrossData(Big.bins=sim$Big.bins, freq.j=sim$freq.j, m.j=sim$m.j)

## Estimate the density underlying the grouped data
obj.fit = degross(obj.data)
print(obj.fit)

}
\references{
Lambert, P. (2021) Moment-based density and risk estimation from grouped summary statistics. arXiv:2107.03883.
}
\seealso{
\code{\link{degross}}, \code{\link{plot.degross}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
