% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_reads_count_primers.R
\name{prepare_reads}
\alias{prepare_reads}
\title{Prepare reads for primer trimming using 'Cutadapt'}
\usage{
prepare_reads(
  data_directory = "data",
  output_directory = tempdir(),
  tempdir_path = NULL,
  tempdir_id = "demulticoder_run",
  overwrite_existing = FALSE
)
}
\arguments{
\item{data_directory}{Directory path where the user has placed
raw FASTQ (forward and reverse reads), metadata.csv, and
primerinfo_params.csv files. Default is "data".}

\item{output_directory}{User-specified directory for outputs. Default is
tempdir().}

\item{tempdir_path}{Path to a temporary directory. If \code{NULL}, a temporary
directory path will be identified using the \code{tempdir()} command.}

\item{tempdir_id}{ID for temporary directories. The user can provide any helpful ID, whether it be a date or specific name for the run. Default is "demulticoder_run"}

\item{overwrite_existing}{Logical, indicating whether to remove or overwrite
existing files and directories from previous runs. Default is \code{FALSE}.}
}
\value{
A list containing data tables, including metadata, primer sequences
to search for based on orientation, paths for trimming reads, and
user-defined parameters for all subsequent steps.
}
\description{
Prepare reads for primer trimming using 'Cutadapt'
}
\examples{
\donttest{
# Pre-filter raw reads and parse metadata and primer_information to prepare
# for primer trimming and filter
analysis_setup <- prepare_reads(
  data_directory = system.file("extdata", package = "demulticoder"),
  output_directory = tempdir(),
  overwrite_existing = TRUE
)
}
}
