% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mov.cor.dm.R
\name{mov.cor.dm}
\alias{mov.cor.dm}
\title{Calculating running correlation between dendrometer data and daily climate.}
\usage{
mov.cor.dm(df, Clim, TreeNum, win_size, cor_method = "pearson")
}
\arguments{
\item{df}{dataframe with first column containing date and time in the format \code{yyyy-mm-dd HH:MM:SS} and the dendrometer data in following columns.}

\item{Clim}{dataframe with the first column containing \code{Date in yyyy-mm-dd} and second column containing corresponding climate data.}

\item{TreeNum}{numerical value indicating the tree to be analysed. E.g. '1' refers to the first dendrometer data column in \emph{df}.}

\item{win_size}{numerical, the running days windows of which the correlation is to be calculated. The minimum value is 18.}

\item{cor_method}{string, method to be applied during correlation calculation. One of the following: pearson, kendall and spearman}
}
\value{
A list of dataframes containing the correlation and significant value between dendrometer series and provided climates.
}
\description{
This function calculates running correlation between dendrometer series and provided climate variables. Users can choose methods such as pearson, kendall and spearman, see \code{cor.test} for further information.
}
\examples{
\donttest{library(dendRoAnalyst)
data(gf_nepa17)
data(ktm_rain17)
out_corr<-mov.cor.dm(df=gf_nepa17, Clim=ktm_rain17, TreeNum=1, win_size=21)
head(out_corr[1],10)}
}
