% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_table.R
\name{sim_table}
\alias{sim_table}
\title{Similarity table of tree-ring curves for the creation of a network}
\usage{
sim_table(trs1,
          trs2=NULL,
          min_overlap=50,
          last_digit_radius=FALSE)
}
\arguments{
\item{trs1}{Rwl object with first tree-ring series to be compared with trs2. A rwl object is a data.frame with series or tree-ring widths as columns and years as rows. This object is created or read by using the dplR-package}

\item{trs2}{Optional second rwl object with second tree-ring series to be compared with trs1. Use this is you have two different datasets that you want to compare. Otherwise all series in trs1 are pair wise compared.}

\item{min_overlap}{If the overlap of the compared series is longer or equal than this minimal value, the similarities will be calculated for the comparison}

\item{last_digit_radius}{Set this to TRUE if the last digit of a series name is the radius of the tree-ring series}
}
\value{
The resulting list includes the names of the compared series, overlap, correlation (both with and without Hollstein-transformation), t-value based on these correlations, SGC, SSGC and the related probability of exceedence.
}
\description{
Function to calculate various similarity measures for the creation of dendrochronological networks as described by Visser (2021a). The function results in a list of all similarities of all comparisons between the tree-ring series in trs1 (or between trs1 and trs2). The resulting list includes the overlap, correlation (both with and without Hollstein-transformation), the t-value based on these correlations, Synchronous Growth Changes (SGC), Semi Synchronous Growth Changes (SSGC), and the related probability of exceedence (p).The last three (SGC, SSGC and p) are explained in Visser (2021b).
}
\examples{
data(hol_rom)
sim_table(hol_rom)
sim_table(hol_rom, last_digit_radius = TRUE)
sim_table(hol_rom, min_overlap = 25)
sim_table(hol_rom, min_overlap = 100, last_digit_radius = TRUE)

}
\references{
Visser, RM. 2021a Dendrochronological Provenance Patterns. Network Analysis of Tree-Ring Material Reveals Spatial and Economic Relations of Roman Timber in the Continental North-Western Provinces. Journal of Computer Applications in Archaeology 4(1): 230–253. DOI: https://doi.org/10.5334/jcaa.79.

Visser, RM. 2021b On the similarity of tree-ring patterns: Assessing the influence of semi-synchronous growth changes on the Gleichläufigkeitskoeffizient for big tree-ring data sets. Archaeometry 63(1): 204–215. DOI: https://doi.org/10.1111/arcm.12600.
}
