% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denscomp.R
\name{denscomp}
\alias{denscomp}
\title{Density Equality Testing}
\usage{
denscomp(
  L,
  group_sizes,
  N.max = 10000,
  a = NULL,
  b = NULL,
  m = 100,
  seed = NULL,
  density.weights = NULL,
  test = c("FDET.regular", "FDET.residual", "FDET.regular.real.imag",
    "FDET.residual.real.imag", "DET.regular", "DET.residual", "MDET.regular",
    "MDET.residual"),
  distance = c("LP", "Hellinger", "TF"),
  moment = c("expectation", "variance", "skewness", "kurtosis", "combined"),
  interpolation = c("linear", "spline"),
  p = 2,
  eps = 0.01,
  tau = 0.01,
  Lmax = 5000,
  ft.lp.weight = c("none", "AbsRoot"),
  real.imag.weights = c(0.5, 0.5),
  moment.weights = rep(0.25, 4),
  plot = FALSE,
  legend = c("topright", "topleft", "bottomright", "bottomleft", "top", "bottom", "left",
    "right", "center")
)
}
\arguments{
\item{L}{A list of estimated density objects, where each element is a list with numeric vectors \code{x} and \code{y}.
\code{x} contains the evaluation points, and \code{y} the corresponding estimated density values for a single observation.}

\item{group_sizes}{A vector indicating the number of densities in each group.}

\item{N.max}{Maximum number of permutations for the test (default: 10000).}

\item{a, b}{Evaluation range endpoints; if NULL, determined from data.}

\item{m}{Number of evaluation points (default: 100).}

\item{seed}{Random seed for reproducibility.}

\item{density.weights}{Optional weights for densities.}

\item{test}{The test to use. One of "FDET.regular", "FDET.residual",
"FDET.regular.real.imag", "FDET.residual.real.imag", "DET.regular", "DET.residual",
"MDET.regular", or "MDET.residual".}

\item{distance}{The distance measure to use for FDET or DET. One of "LP", "Hellinger", or "TF".}

\item{moment}{Moment type used for MDET. One of "expectation", "variance", "skewness", "kurtosis", or "combined".}

\item{interpolation}{Method for interpolating densities. One of "linear" or "spline".}

\item{p}{Parameter for \eqn{L^p} distances (default: 2).}

\item{eps}{Cut-off parameter for the Fourier transforms.}

\item{tau}{Step size parameter of the Fourier Transforms.}

\item{Lmax}{Maximum size of the vectors containing the values of the individual Fourier transforms.}

\item{ft.lp.weight}{Weights for the Fourier transforms. One of "none" or "AbsRoot".}

\item{real.imag.weights}{Weights for the real and imaginary parts of the Fourier transforms.}

\item{moment.weights}{Internal parameters for specific methods.}

\item{plot}{Logical. If TRUE, plots the density functions in \code{L}.}

\item{legend}{Position of the legend in the plot.}
}
\value{
A \eqn{p}-value indicating the significance of group differences.
}
\description{
This is the main function of the \code{denstest} package. It performs statistical tests
for the equality between groups of estimated density functions using FDET, DET, or MDET.
}
\examples{
n1 <- 5; n2 <- 5; n3 <- 5
group_sizes <- c(n1, n2, n3)
sample_size <- 500

densities_group1 <- lapply(1:n1, function(i) {
  data <- rnorm(sample_size, 0, 0.3)
  d <- density(data)
  list(x = d$x, y = d$y)
})

densities_group2 <- lapply(1:n2, function(i) {
  data <- rnorm(sample_size, 0, 0.32)
  d <- density(data)
  list(x = d$x, y = d$y)
})

densities_group3 <- lapply(1:n3, function(i) {
  data <- rnorm(sample_size, 0.02, 0.28)
  d <- density(data)
  list(x = d$x, y = d$y)
})

L <- c(densities_group1, densities_group2, densities_group3)

denscomp(L, group_sizes, ft.lp.weight = "AbsRoot")
}
\references{
Anarat A., Krutmann, J., and Schwender, H. (2025). Testing for Differences in Extrinsic Skin Aging Based on Density
Functions. Submitted.

Delicado, P. (2007). Functional k-sample problem when data are density functions. Computational Statistics, 22, 391–410. \doi{10.1007/s00180-007-0047-y}
}
\author{
Akin Anarat \email{akin.anarat@hhu.de}
}
