% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependentsim.R
\name{remove_dependence}
\alias{remove_dependence}
\title{Remove all dependence in a random structure}
\usage{
remove_dependence(random_structure)
}
\arguments{
\item{random_structure}{A random structure from get_random_structure()}
}
\value{
The random structure with dependency removed, so all data generated from it will be independent.
}
\description{
Remove all dependence in a random structure
}
\examples{
library(MASS)
Sigma = matrix(c(
  1,      0.8,    0,  0,  0,  0,
  0.8,    1,      0,  0,  0,  0,
  0,      0,      1,  0,  0,  0,
  0,      0,      0,  1,  0,  0,
  0,      0,      0,  0,  1,  0.3,
  0,      0,      0,  0,  0.3, 1
), nrow=6, ncol=6)
norm_data <- t(mvrnorm(n=20, mu=c(0,0,0,0,0,0), Sigma=Sigma))

# Simulate draws mimicking that data but without any dependence
rs_normal <- get_random_structure(list(data=norm_data), method="pca", rank=2, type="normal")
rs_indep <- remove_dependence(rs_normal)
draws_indep <- draw_from_multivariate_corr(rs_indep, n_samples=30)
}
