agg.wtd.var <- function(x, by, weights = NULL, na.rm = FALSE) {
  if(is.null(weights)) weights <- rep(1, nrow(data.frame(x)))
  res <- split(data.frame(weights,x), by)
  if(ncol(res[[1]])==2) {
    res <- data.frame(var = sapply(res, function(z) weighted.sd(z[,2], z[,1], na.rm = na.rm)))
  } else {
    res <- do.call("rbind.data.frame", args = lapply(res, function(z) sapply(z[,-1], weighted.sd, weights = z[,1], na.rm = na.rm)))
    rownames(res) <- levels(by)
    colnames(res) <- colnames(x)
  }
  res <- res * res
  return(res)
}