% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/destrunc.R
\name{destrunc}
\alias{destrunc}
\title{Calculate skewness and kurtosis based on truncated normal distribution in one group}
\usage{
destrunc(
  vmean,
  vsd,
  lo,
  hi,
  rawdata = NULL,
  showFigure = FALSE,
  xstart,
  btol,
  ftol,
  ...
)
}
\arguments{
\item{vmean}{sample mean of the truncated data}

\item{vsd}{sample standard deviation of the truncated data}

\item{lo}{minimum possible value}

\item{hi}{maximum possible value}

\item{rawdata}{when raw data is available, we could still use it to check it figuratively, if the data was closed to the normal distribution, or truncated normal distribution.}

\item{showFigure}{when showFigure = TRUE, it will display the plots with theoretical normal curve and the truncated normal curve.}

\item{xstart}{see the package \code{\link[nleqslv]{nleqslv}}}

\item{btol}{see the package \code{\link[nleqslv]{nleqslv}}}

\item{ftol}{see the package \code{\link[nleqslv]{nleqslv}}}

\item{...}{other arguments}
}
\value{
If `showFigure = TRUE`, the output will be a list with two objects: one is the data frame of parent mean and standard deviation (pmean and psd), mean and standard deviation of truncated normal distribution (mean and sd), and skewness and kurtosis; the other is the theoretical figures of beta and normal distributions. If `showFigure = FALSE`, the output will be only the data frame.
}
\description{
This function can be used to calculate the skewness and kurtosis based on the truncated normal distribution. Also, it can be used to estimate the mean and variance of the parent distribution (the distribution before truncated).
}
\examples{
data("trun_mdat")
destrunc(vmean=trun_mdat$m2[6], vsd=trun_mdat$sd2[6],
hi = 4, lo = 0, showFigure = TRUE)
#example2
destrunc(vmean=trun_mdat$m1[17], vsd=trun_mdat$sd1[17],
hi = 4, lo = 0, showFigure = TRUE)

}
\references{
\insertRef{shah1966estimation}{detectnorm}

\insertRef{robert1995simulation}{detectnorm}

\insertRef{barr1999mean}{detectnorm}
}
\seealso{
\code{\link{desbeta}}
}
