% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_infinite_estimates.R,
%   R/zzz_conventions.R
\name{detect_infinite_estimates}
\alias{detect_infinite_estimates}
\alias{detectInfiniteEstimates}
\title{Detect Infinite Estimates}
\usage{
detect_infinite_estimates(
  x,
  y,
  weights = NULL,
  start = NULL,
  etastart = NULL,
  mustart = NULL,
  offset = NULL,
  family = gaussian(),
  control = list(),
  intercept = TRUE,
  singular.ok = TRUE
)

detectInfiniteEstimates(
  x,
  y,
  weights = NULL,
  start = NULL,
  etastart = NULL,
  mustart = NULL,
  offset = NULL,
  family = gaussian(),
  control = list(),
  intercept = TRUE,
  singular.ok = TRUE
)
}
\arguments{
\item{x}{\code{x} is a design matrix of dimension \code{n * p}.}

\item{y}{\code{y} is a vector of observations of length \code{n}.}

\item{weights}{an optional vector of \sQuote{prior weights} to be used
    in the fitting process.  Should be \code{NULL} or a numeric vector.}

\item{start}{currently not used.}

\item{etastart}{currently not used.}

\item{mustart}{currently not used.}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during fitting.
    This should be \code{NULL} or a numeric vector of length equal to
    the number of cases.  One or more \code{\link[stats]{offset}} terms can be
    included in the formula instead or as well, and if more than one is
    specified their sum is used.  See \code{\link[stats]{model.offset}}.}

\item{family}{a description of the error distribution and link
    function to be used in the model.  For \code{glm} this can be a
    character string naming a family function, a family function or the
    result of a call to a family function.  For \code{glm.fit} only the
    third option is supported.  (See \code{\link[stats]{family}} for details of
    family functions.)}

\item{control}{a list of parameters controlling separation
detection. See \code{\link{detect_separation_control}} for
details.}

\item{intercept}{logical. Should an intercept be included in the
    \emph{null} model?}

\item{singular.ok}{logical. If \code{FALSE}, a singular model is an
error.}
}
\description{
Method for \code{\link{glm}} that detects infinite components in
the maximum likelihood estimates of generalized linear models
with binomial responses.
}
\details{
For binomial-response generalized linear models with \code{"log"}
link, separated data allocations do not necessarily lead to
infinite maximum likelihood estimates. For this reason, for models
with the \code{"log"} link
\code{\link{detect_infinite_estimates}()} relies on an alternative
linear optimization model developed in Schwendinger et al. (2021),
and for all the other supported links it relies on the linear
programming methods developed in Konis (2007). See
\code{\link{detect_separation}()} for definitions and details.

\code{\link{detect_infinite_estimates}()} is a wrapper to the
functions \code{separator_ROI()}, \code{separator_lpSolveAPI()} (a
modified version of the \code{separator()} function from the
**safeBinaryRegression** R package), and \code{dielb_ROI()}.

The \code{\link{coefficients}()} method extracts a vector of values
for each of the model parameters under the following convention:
\code{0} if the maximum likelihood estimate of the parameter is
finite, and \code{Inf} or \code{-Inf} if the maximum likelihood
estimate of the parameter if plus or minus infinity. This
convention makes it easy to adjust the maximum likelihood estimates
to their actual values by element-wise addition.

\code{\link{detect_infinite_estimates}()} can be passed directly as
a method to the \code{\link{glm}} function. See, examples.

\code{detectInfiniteEstimates}() is an alias for
\code{detect_infinite_estimates}().
}
\examples{
# The classical example given in Silvapulle (1981) can be utilized
# to show that for the Log-Binomial model there exist data allocations
# which are separated but produce finite estimates.
data("silvapulle1981", package = "detectseparation")

# Since the data is separated the MLE does not exist for the logit link.
glm(y ~ ghqs, data = silvapulle1981, family = binomial(),
    method = "detect_infinite_estimates")

# However, for the log link all components of the MLE are finite.
glm(y ~ ghqs, data = silvapulle1981, family = binomial("log"),
    method = "detect_infinite_estimates")
glm(y ~ ghqs, data = silvapulle1981, family = binomial("log"), start = c(-1, 0))

}
\references{
Silvapulle, M. J. (1981).
On the Existence of Maximum Likelihood Estimators for the Binomial Response Models.
Journal of the Royal Statistical Society. Series B (Methodological), 43(3), 310–313.
\url{https://www.jstor.org/stable/2984941}

Konis K. (2007). *Linear Programming Algorithms for Detecting
Separated Data in Binary Logistic Regression
Models*. DPhil. University of Oxford.
\url{https://ora.ox.ac.uk/objects/uuid:8f9ee0d0-d78e-4101-9ab4-f9cbceed2a2a}

Konis K. (2013). safeBinaryRegression: Safe Binary Regression. R
package version 0.1-3.
\url{https://CRAN.R-project.org/package=safeBinaryRegression}

Kosmidis I. and Firth D. (2021). Jeffreys-prior penalty, finiteness
and shrinkage in binomial-response generalized linear
models. *Biometrika*, **108**, 71–82. \doi{10.1093/biomet/asaa052}

Schwendinger, F., Grün, B. & Hornik, K. (2021). A comparison of
optimization solvers for log binomial regression including conic
programming.  *Computational Statistics*, **36**,
1721–1754. \doi{10.1007/s00180-021-01084-5}
}
\seealso{
\code{\link{glm.fit}} and \code{\link{glm}}, \code{\link{detect_separation}}, \code{\link{check_infinite_estimates}}, \code{\link[brglm2]{brglm_fit}}
}
\author{
Ioannis Kosmidis [aut, cre] \email{ioannis.kosmidis@warwick.ac.uk}, Florian Schwendinger [aut] \email{FlorianSchwendinger@gmx.at}, Dirk Schumacher [aut] \email{mail@dirk-schumacher.net}, Kjell Konis [ctb] \email{kjell.konis@me.com}
}
