% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RwlInfo.R
\name{RwlInfo}
\alias{RwlInfo}
\title{Compute some common statistics on individual ring-width series.}
\usage{
RwlInfo(rwl, print=TRUE, chrono=NULL)
}
\arguments{
\item{rwl}{a data.frame with ring-width series as columns and years as rows.}

\item{print}{logical flag. If TRUE the output is printed in the console.}

\item{chrono}{If NULL the function computes a mean chronology using all series presented in the data.frame (rwl).}
}
\value{
A data.frame with the descriptive statistics for each series.
}
\description{
Compute some common statistics on individual ring-width series.
}
\details{
This function computes some common descriptive statistics on individual series, such as the correlation with the master chronology, mean, median, standard deviation, mean sensitivity and first-order autocorrelation, and the output can be printed to the R editor window
}
\examples{
\dontshow{
set.seed(1)
 rwl <- matrix(sample(1:1000,1000), ncol = 10, dimnames = list(c(1:100),1:10))
 rwl[49,] <- 100
 rwl[50,] <- 1
 rwl[51,] <- 100
 rwl <- as.rwl(rwl)
 RwlInfo(rwl)}
\dontrun{
data(co021, package = "dplR")
RwlInfo(co021)
co021.info <- RwlInfo(co021, print = FALSE)
write(co021.info)
}

}
\references{
Bunn, A. 2008. A dendrochronology program library in R (dplR). Dendrochronologia 26:115-124.
}
