% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_lifetraits.R
\name{dRGetMetricsInfo}
\alias{dRGetMetricsInfo}
\title{Life traits from the ectotherm database}
\usage{
dRGetMetricsInfo(
  eq,
  prec = 0.1,
  lowTempLim = 0,
  highTempLimit = 60,
  devLimit = 0.01,
  devThresh = 0.1,
  lifeStage = "all",
  colId = "genSp",
  printOut = FALSE
)
}
\arguments{
\item{eq}{The name of the equation.}

\item{prec}{The precision for the temperature (default = 0.1 degree
celsius).}

\item{lowTempLim}{The minimum temperature for the metrics (default = 0
degree celsius).}

\item{highTempLimit}{The maximum temperature for the metrics (default =
+60 degree celsius).}

\item{devLimit}{The development rate considered as null (default = 0.01).}

\item{devThresh}{The threshold in development rate to compute min and max
temperature (default = 0.1).}

\item{lifeStage}{The life stage on which the life traits should be
computed (default = "all"; specify "" to take into account all life
stages).}

\item{colId}{The organism information for each column (default = genSp;
choices = "ordersp" for Order, "familysp" for Family, "genussp" for
Genus, "species" for species, and "gensp" for Genus and species).}

\item{printOut}{A logical to print the result (default = FALSE).}
}
\value{
A matrix with one column per organism and one row for each
  metric. The metrics names are the names of each row.
}
\description{
Life traits from the ectotherm database
}
\examples{
dRGetMetricsInfo(eq = taylor_81)
dRGetMetricsInfo(eq = taylor_81, devThresh = 0.1)
}
