\name{crmsim}
\alias{crmsim}
\alias{onetrial}
\alias{mtrials}
\alias{plot.sim}
\alias{print.sim}
\title{CRM Simulator}
\description{
  \code{crmsim} is used to generate simulation replicates of phase I
  trial using the (group) CRM under a specified dose-toxicity
  configuration.
}

\usage{
crmsim(PI, prior, target, n, x0, nsim = 1, mcohort = 1, restrict = TRUE, 
    count = TRUE, method = "bayes", model = "empiric", intcpt = 3, 
    scale = sqrt(1.34), seed = 1009) 
}

\arguments{
  \item{PI}{A vector of the true toxicity probabilites associated with
    the doses.}
  
  \item{prior}{A vector of initial guesses of toxicity probabilities
    associated with the doses.  Must be of same length as \code{PI}.}
  
  \item{target}{The target DLT rate.}
  
  \item{n}{Sample size of the trial.}
  
  \item{x0}{The initial design.  For one-stage TITE-CRM, it is a
    single numeric value indicating the starting dose.  For two-stage
    TITE-CRM, it is a non-decreasing sequence of dose levels of length
    \code{n}.}

  \item{nsim}{The number of simulations.  Default is set at 1.}

  \item{mcohort}{The number of patients enrolled before the next
    model-based update.  Default is set at 1, i.e., a fully sequential
    update.}
  
  \item{restrict}{If TRUE, restrictions apply during the
    trials to avoid (1) skipping doses in escalation and (2) escalation
    immediately after a toxic outcome (i.e., incoherent escalation).  If
    FALSE, dose assignments are purely model-based.}
  
  \item{count}{If TRUE, the number of the current simulation replicate
    will be displayed.}
  
  \item{method}{A character string to specify the method for parameter
    estimation.  The default method ``bayes'' estimates the model
    parameter by the posterior mean.  Maximum likelihood estimation is
    specified by ``mle''.}
  
  \item{model}{A character string to specify the working model used in
    the method.  The default model is ``empiric''.  A one-parameter
    logistic model is specified by ``logistic''.}

  \item{intcpt}{The intercept of the working logistic model.  The
    default is 3.  If \code{model}=``empiric'', this argument will be
    ignored.}
    
  \item{scale}{Standard deviation of the normal prior of the model
    parameter.  Default is sqrt(1.34).}
  
  \item{seed}{Seed of the random number generator.}
}

\value{
  An object of class ``sim'' is returned, consisting of the operating
  characteristics of the design specified.  The time component of the
  design is suppressed for the CRM simulator.  All ``sim'' objects
  generated by \code{crmsim} contain at least the following components:
      
  \item{PI}{True toxicity rates.}
  
  \item{prior}{Initial guesses of toxicity rates.}

  \item{target}{The target probability of toxicity at the MTD.}

  \item{n}{Sample size.}

  \item{x0}{The initial design.}

  \item{MTD}{Distribution of the MTD estimates.  If \code{nsim}=1, this
    is a single numeric value of the recommended MTD of in simulated
    trial.}
    
  \item{level}{Average number of patients treated at the test doses.  If
    \code{nsim}=1, this is a vector of length \code{n} indicating the
    doses assigned to the patients in the simulated trial.}

  \item{tox}{Average number of toxicities seen at the test doses.  If
    \code{nsim}=1, this is a vector of length \code{n} indicating the
    toxicity outcomes of the patients in the simulated trial.}
  
  \item{beta.hat}{The estimates of the model parameter throughout the
    simulated trial(s).  The dose assignment of the jth patient in each
    trial corresponds to the jth element in each row.}

  \item{final.est}{The final estimates of the model parameter of the
    simulated trials.}

  
}


\seealso{
  \code{\link{crm}}, \code{\link{titesim}}.
}

\references{
  O'Quigley, J. O., Pepe, M., and Fisher, L. (1990).  Continual
  reassessment method: A practical design for phase I clinical trials in
  cancer.  Biometrics 46:33-48.
  
  Cheung, Y. K. (2005). Coherence principles in dose-finding studies.
  Biometrika 92:863-873.
  
  Cheung, Y. K. (2011).  Dose Finding by the Continual Reassessment Method.  New York: Chapman & Hall/CRC Press.
}

\examples{
PI <- c(0.10, 0.20, 0.40, 0.50, 0.60, 0.65)
prior <- c(0.05, 0.10, 0.20, 0.35, 0.50, 0.70)
target <- 0.2
x0 <- c(rep(1,3), rep(2,3), rep(3,3), rep(4,3), rep(5,3), rep(6,9))

# Generate a single replicate of two-stage group CRM trial of group size 3
foo <- crmsim(PI, prior, target, 24, x0, mcohort=3)
\dontrun{plot(foo,ask=T)}  # summarize trial graphically

# Generate 10 replicates of CRM trial with 24 subjects
foo10 <- crmsim(PI, prior, target, 24, 3, nsim=10, mcohort=2)
foo10
}

\keyword{datasets}
