% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prepare_plot_data}
\alias{prepare_plot_data}
\title{Prepare Plot Data}
\usage{
prepare_plot_data(
  data,
  cat_a,
  cat_b,
  cat_c,
  group,
  var_positions,
  cat_a_order,
  cat_b_order
)
}
\arguments{
\item{data}{A data frame containing the variables.}

\item{cat_a}{The name of the column representing category A.}

\item{cat_b}{The name of the column representing category B.}

\item{cat_c}{The name of the column representing category C.}

\item{group}{The name of the column representing the grouping variable.}

\item{var_positions}{A data frame with variable positions, typically output from \code{create_var_positions}.}

\item{cat_a_order}{A vector specifying the order of category A.}

\item{cat_b_order}{A vector specifying the order of category B.}
}
\value{
A data frame ready for plotting with added x_pos and y_pos columns.
}
\description{
Prepares data for plotting by calculating positions based on provided variable positions and orders.
}
\examples{
library(dplyr)
data <- data.frame(
  cat_a = rep(letters[1:3], each = 4),
  cat_b = rep(LETTERS[1:2], times = 6),
  cat_c = rep(c("Var1", "Var2"), times = 6),
  group = rep(c("G1", "G2"), times = 6)
)
var_positions <- data.frame(
  var = c("Var1", "Var2"),
  x_offset = c(0.1, -0.1),
  y_offset = c(0.1, -0.1)
)
cat_a_order <- c("a", "b", "c")
cat_b_order <- c("A", "B")
prepare_plot_data(data, "cat_a", "cat_b", "cat_c", "group", var_positions, cat_a_order, cat_b_order)
}
