% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathEnrich.R
\name{pathEnrich}
\alias{pathEnrich}
\alias{print.pathEnrich}
\alias{summary.pathEnrich}
\title{pathEnrich}
\usage{
pathEnrich(gk_obj, gene_list, method = "BH", cutoff = 0.05, N = 2)

\method{print}{pathEnrich}(x, ...)

\method{summary}{pathEnrich}(object, ...)
}
\arguments{
\item{gk_obj}{list. Object genrated from \code{get_kegg}, or a list containing the
output generated from a past \code{get_kegg} call. Names of the list must match those
defined in \code{get_kegg}. If the user wishes to use an older version of data
generated by \code{get_kegg}, they must first load that data and put it in a named
list that matches the names given in the list generated by \code{get_kegg}.}

\item{gene_list}{Vector. Vector of NCBI (ENTREZ) geneIDs.}

\item{method}{Character. Character string telling \code{diffEnrich} which method to
use for multiple testing correction. Available methods are those provided by
\code{\link{p.adjust}}, and the default is "BH", or False Discovery Rate (FDR).}

\item{cutoff}{Numeric. The p-value threshold to be used as the cutoff when determining statistical significance, and used to filter list of significant pathways.}

\item{N}{Numeric. The number of genes from the gene list that must be present in a KEGG pathway in order for that pathway to be retained and tested.}

\item{x}{object of class \code{pathEnrich}}

\item{\dots}{Unused}

\item{object}{object of class \code{pathEnrich}}
}
\value{
A list object of class \code{pathEnrich} that contains 6 items:

\describe{
\item{species}{The species used in enrichment}
\item{padj}{The method used to correct for multiple testing}
\item{sig_paths}{The KEGG pathways the reached statistical significance after multiple testing correction.}
\item{cutoff}{The p-value threshold to be used as the cutoff when determining statistical significance, and used to filter final results data set.}
\item{N}{The number of genes from the gene list that must be present in a KEGG pathway in order for that pathway to be retained and tested.}
\item{enrich_table}{A data frame that summarizes the results of the pathway analysis and contains the following variables:}
}

\describe{
  \item{KEGG_PATHWAY_ID}{KEGG Pathway Identifier}
  \item{KEGG_PATHWAY_description}{Description of KEGG Pathway (provided by KEGG)}
  \item{KEGG_PATHWAY_cnt}{Number of Genes in KEGG Pathway}
  \item{KEGG_PATHWAY_in_list}{Number of Genes from gene list in KEGG Pathway}
  \item{KEGG_DATABASE_cnt}{Number of Genes in KEGG Database}
  \item{KEGG_DATABASE_in_list}{Number of Genes from gene list in KEGG Database}
  \item{expected}{Expected number of genes from list to be in KEGG pathway by chance (i.e., not enriched)}
  \item{enrich_p}{P-value for enrichment of list genes related to KEGG pathway}
  \item{p_adj}{False Discovery Rate (Benjamini and Hochberg) to account for multiple testing across KEGG pathways}
  \item{fold_enrichment}{KEGG_PATHWAY_in_list/expected}
}
}
\description{
This function takes the list generated in \code{\link{get_kegg}} as well as a vector
of NCBI (ENTREZ) geneIDs, and identifies significantly enriched KEGG pathways using
a Fisher's Exact Test. Unadjusted p-values as well as FDR corrected p-values are
calculated.
}
\details{
This function may not always use the complete list of genes provided by the user.
Specifically, it will only use the genes from the list provided that are also in
the most current species list pulled from the KEGG REST API, or from the older data KEGG
loaded by the user. The 'cutoff' only filters the list of pathways provided in the 'sig_paths'
list item. It is not used to filter the 'enrich_table' list object. S3 generic functions for \code{print} and \code{summary} are
provided. The \code{print} function prints the results table as a \code{tibble}, and the
\code{summary} function returns the number of pathways that reached statistical significance,
as well as their descriptions, the number of genes used from the KEGG data base, the KEGG species, and the
method used for multiple testing correction, and the p-value cutoff required for reaching statistical significance.
}
\examples{

list1_pe <- pathEnrich(gk_obj = kegg, gene_list = geneLists$list1)
\dontrun{
list2_pe <- pathEnrich(gk_obj = kegg, gene_list = geneLists$list2, method = 'none', N = 4)
}

}
