% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_sampler.R
\name{sensitivitySamplerManual}
\alias{sensitivitySamplerManual}
\title{Sensitivity sampler for \code{\link{DPMech-class}}.}
\usage{
sensitivitySamplerManual(object, oracle, n, m, k)
}
\arguments{
\item{object}{an object of class \code{\link{DPMech-class}}.}

\item{oracle}{a source of random databases. A function returning: list,
matrix/data.frame (data in rows), numeric/character vector of records if
given desired length > 1; or single record given length 1, respectively
a list element, a row/named row,  a single numeric/character. Whichever
type is used should be expected by \code{object@target}.}

\item{n}{database size scalar positive numeric, integer-valued.}

\item{m}{sensitivity sample size scalar positive numeric, integer-valued.}

\item{k}{order statistic index in {1,...,\code{m}}.}
}
\value{
\code{object} with updated sensitivity parameter.
}
\description{
Given a constructed \code{\link{DPMech-class}}, complete with \code{target}
function and \code{sensitivityNorm,} and an \code{oracle} for producing
records, samples the sensitivity of the target function to set the
mechanism's \code{sensitivity}. Typically the method
\code{\link{sensitivitySampler}} should be used instead; NOTE this method
does not properly set the \code{gammaSensitivity} slot of
\code{\link{DPMech-class}} unlike the preferred method.
}
\examples{
## Simple example with unbounded data hence no global sensitivity.
f <- function(xs) mean(xs)
m <- DPMechLaplace(target = f, dims = 1)
P <- function(n) rnorm(n)
m <- sensitivitySamplerManual(m, oracle = P, n = 100, m = 10, k = 10)
m@sensitivity

}
\references{
Benjamin I. P. Rubinstein and Francesco Aldà. "Pain-Free Random Differential
  Privacy with Sensitivity Sampling", accepted into the 34th International
  Conference on Machine Learning (ICML'2017), May 2017.
}
\seealso{
\code{\link{sensitivitySampler}} preferred method for sensitivity
  sampling.
}
