% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epsilonCompute.R
\name{epsilonCompute}
\alias{epsilonCompute}
\title{Compute default diffusion map epsilon.}
\usage{
epsilonCompute(D, p = 0.01)
}
\arguments{
\item{D}{n-by-n pairwise distance matrix for a data set with n points, or
alternatively output from the dist() function}

\item{p}{distances to p*n-th nearest neighbor are used.  Default value is
.01}
}
\value{
\item{epsilon }{value of epsilon to be used in diffusion map}
}
\description{
Uses the pair-wise distances to estimate a diffusion map epsilon value by
the median p*n-th nearest neighbor
}
\details{
Function is used as the default value in diffuse().  For inference problems,
it is advised that the results be optimized over epsilon.
}
\examples{
data(annulus)
D = dist(annulus) # use Euclidean distance
epsilonCompute(D,.005)
epsilonCompute(D,.01)
epsilonCompute(D,.05)
epsilonCompute(D,.1)
}
\seealso{
\code{\link[=diffuse]{diffuse()}}
}
\keyword{multivariate}
\keyword{nonparametric}
