% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHSAF.R
\name{getHSAF}
\alias{getHSAF}
\title{High Spectral Anomaly Frequency (HSAF)}
\usage{
getHSAF(resid, years, for.year = NULL)
}
\arguments{
\item{resid}{A vector of residual values generated with respect to the baseline signal}

\item{years}{A vector of years corrosponding to the residual values}

\item{for.year}{(optional) Calculate HSAF values only for the given year in this argument.
If argument is omitted, HSAF values for all years are calculated.}
}
\value{
Data frame containing two Columns:
\tabular{ll}{
\code{year} \tab First column, represents year \cr
\code{HSAF} \tab Second column, represents HSAF values
}
}
\description{
Compute High Spectral Anomaly Frequency (HSAF) from the given residual values.
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# HSAF
hsaf = getHSAF(x.bl$resid.sig, x.streamflow$data$year)

}
