% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized.R
\name{realized_compute}
\alias{realized_compute}
\alias{realized_count}
\alias{realized_total}
\alias{realized_value}
\alias{realized_duration}
\alias{realized_empty}
\title{Realized estimation}
\usage{
realized_count(
  portfolio_quantity,
  portfolio_price,
  transaction_quantity,
  transaction_price,
  transaction_type,
  allow_short = TRUE,
  realized_only = FALSE
)

realized_total(
  portfolio_quantity,
  portfolio_price,
  transaction_quantity,
  transaction_price,
  transaction_type,
  allow_short = TRUE,
  realized_only = FALSE
)

realized_value(
  portfolio_quantity,
  portfolio_price,
  transaction_quantity,
  transaction_price,
  transaction_type,
  allow_short = TRUE,
  realized_only = FALSE
)

realized_duration(
  portfolio_quantity,
  portfolio_price,
  transaction_quantity,
  transaction_price,
  transaction_type,
  previous_transaction_datetime,
  previous_datetime,
  transaction_datetime,
  allow_short = TRUE,
  realized_only = FALSE
)

realized_compute(
  portfolio_quantity,
  portfolio_price,
  transaction_quantity,
  transaction_price,
  transaction_type,
  previous_transaction_datetime,
  previous_datetime,
  transaction_datetime,
  transaction_asset,
  allow_short = TRUE,
  realized_only = FALSE,
  method = "all"
)

realized_empty(transaction_asset, method = "all")
}
\arguments{
\item{portfolio_quantity}{Numeric vector. The portfolio quantities of assets into the
investor's portfolio.}

\item{portfolio_price}{Numeric vector. The portfolio prices of assets into the
investor's portfolio.}

\item{transaction_quantity}{Numeric value. The quantity of the traded asset.}

\item{transaction_price}{Numeric value. The market price of the traded asset.}

\item{transaction_type}{Character string. Either "B" = buy or "S" = sell.}

\item{allow_short}{Logical. If TRUE short positions are allowed, otherwise only
long positions are allowed.}

\item{realized_only}{Logical. If TRUE only realized gains and realized
losses are computed. Otherwise also paper gains and paper losses on excess
quantity of the traded asset are computed.}

\item{previous_transaction_datetime}{POSIXct value. The portfolio date-time related to the
last transaction of the traded asset.}

\item{previous_datetime}{POSIXct value. The date-time of the last transaction
performed by the investor.}

\item{transaction_datetime}{POSIXct value. The date-time at which the transaction
is going to occur.}

\item{transaction_asset}{Character string. The name of the traded asset.}

\item{method}{Character string. The method used to compute papers.
Allowed values are "count", "total", "value", "duration" and "all".}
}
\value{
The described functions have different return behaviors
\itemize{
\item \code{realized_compute} returns a data frame
containing the values of realized and paper gains and losses computed by
means of the chosen method on each portfolio assets.
\item \code{realized_count} returns a named vector containing the values
of realized and paper gains and losses computed using the count method.
\item \code{realized_total} returns a named vector containing the values
of realized and paper gains and losses computed using the total method.
\item \code{realized_value} returns a named vector containing the values
of realized and paper gains and losses computed using the value method.
\item \code{realized_duration} returns a named vector containing the values
of realized and paper gains and losses computed using the duration method.
\item \code{realized_empty} returns a named vector containing empty values
of realized and paper gains and losses computed using the chosen method.
}

In particular:
\itemize{
\item \code{RG_"method"} contains Realized Gains results
\item \code{RL_"method"} contains Realized Losses results
\item \code{PG_"method"} contains Paper Gains results
\item \code{PL_"method"} contains Paper Losses results
}
}
\description{
Compute realized gains and realized losses as either simple
counts, total quantities, expected returns and financial duration.
}
\section{Functions}{
\itemize{
\item \code{realized_count}: Computation, as simple counts, of realized
gains and realized losses of the traded asset.

\item \code{realized_total}: Computation, as total quantity, of realized
gains and realized losses of the traded asset.

\item \code{realized_value}: Computation, as expected return, of
realized gains and realized losses of the traded asset.

\item \code{realized_duration}: Computation, as financial duration, of
realized gains and realized losses of the traded asset.

\item \code{realized_compute}: Wrapper that calls other realized_. functions to
compute realized gains and realized losses of the traded asset based on the
chosen method.

\item \code{realized_empty}: Simple function to obtain empty results for
realized and paper computations based on the chosen method.
}}

\seealso{
\code{\link{paper_compute}}, \code{\link{gains_losses}}
}
