% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distantia_dtw_plot.R
\name{distantia_dtw_plot}
\alias{distantia_dtw_plot}
\title{Two-Way Dissimilarity Plots of Time Series Lists}
\usage{
distantia_dtw_plot(
  tsl = NULL,
  distance = "euclidean",
  diagonal = TRUE,
  bandwidth = 1,
  matrix_type = "cost",
  matrix_color = NULL,
  path_width = 1,
  path_color = "black",
  diagonal_width = 1,
  diagonal_color = "white",
  line_color = NULL,
  line_width = 1,
  text_cex = 1
)
}
\arguments{
\item{tsl}{(required, time series list) list of zoo time series. Default: NULL}

\item{distance}{(optional, character vector) name or abbreviation of the distance method. Valid values are in the columns "names" and "abbreviation" of the dataset \link{distances}. Default: "euclidean".}

\item{diagonal}{(optional, logical vector). If TRUE, diagonals are included in the dynamic time warping computation. Default: TRUE}

\item{bandwidth}{(optional, numeric) Proportion of space at each side of the cost matrix diagonal (aka \emph{Sakoe-Chiba band}) defining a valid region for dynamic time warping, used to control the flexibility of the warping path. This method prevents degenerate alignments due to differences in magnitude between time series when the data is not properly scaled. If \code{1} (default), DTW is unconstrained. If \code{0}, DTW is fully constrained and the warping path follows the matrix diagonal. Recommended values may vary depending on the nature of the data. Ignored if \code{lock_step = TRUE}. Default: 1.}

\item{matrix_type}{(optional, character string): one of "cost" or "distance" (the abbreviation "dist" is accepted as well). Default: "cost".}

\item{matrix_color}{(optional, character vector) vector of colors for the distance or cost matrix. If NULL, uses the palette "Zissou 1" provided by the function \code{\link[grDevices:palettes]{grDevices::hcl.colors()}}. Default: NULL}

\item{path_width}{(optional, numeric) width of the least cost path. Default: 1}

\item{path_color}{(optional, character string) color of the least-cost path. Default: "black"}

\item{diagonal_width}{(optional, numeric) width of the diagonal. Set to 0 to remove the diagonal line. Default: 0.5}

\item{diagonal_color}{(optional, character string) color of the diagonal. Default: "white"}

\item{line_color}{(optional, character vector) Vector of colors for the time series plot. If not provided, defaults to a subset of \code{matrix_color}.}

\item{line_width}{(optional, numeric vector) Width of the time series plot. Default: 1}

\item{text_cex}{(optional, numeric) Multiplier of the text size. Default: 1}
}
\value{
multipanel plot
}
\description{
Plots two sequences, their distance or cost matrix, their least cost path, and all relevant values used to compute dissimilarity.

Unlike \code{\link[=distantia]{distantia()}}, this function does not accept vectors as inputs for the arguments to compute dissimilarity (\code{distance}, \code{diagonal},  and \code{weighted}), and only plots a pair of sequences at once.

The argument \code{lock_step} is not available because this plot does not make sense in such a case.
}
\examples{
#three time series
#climate and ndvi in Fagus sylvatica stands in Spain, Germany, and Sweden
#convert to time series list
#scale and center to neutralize effect of different scales in temperature, rainfall, and ndvi
tsl <- tsl_initialize(
  x = fagus_dynamics,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_global #see help(f_scale_global)
  )

if(interactive()){
  tsl_plot(
    tsl = tsl,
    guide_columns = 3
    )
}

#visualize dynamic time warping
if(interactive()){

  #plot pair with cost matrix (default)
  distantia_dtw_plot(
    tsl = tsl[c("Spain", "Sweden")] #only two time series!
  )

  #plot pair with distance matrix
  distantia_dtw_plot(
    tsl = tsl[c("Spain", "Sweden")],
    matrix_type = "distance"
  )

  #plot pair with different distance
  distantia_dtw_plot(
    tsl = tsl[c("Spain", "Sweden")],
    distance = "manhattan", #sed data(distances)
    matrix_type = "distance"
  )


  #with different colors
  distantia_dtw_plot(
    tsl = tsl[c("Spain", "Sweden")],
    matrix_type = "distance",
    matrix_color = grDevices::hcl.colors(
      n = 100,
      palette = "Inferno"
    ),
    path_color = "white",
    path_width = 2,
    line_color = grDevices::hcl.colors(
      n = 3, #same as variables in tsl
      palette = "Inferno"
    )
  )

}
}
\seealso{
Other distantia: 
\code{\link{distantia}()},
\code{\link{distantia_dtw}()},
\code{\link{distantia_ls}()}
}
\concept{distantia}
