% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_to_df.R
\name{tsl_to_df}
\alias{tsl_to_df}
\title{Transform Time Series List to Data Frame}
\usage{
tsl_to_df(tsl = NULL)
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}
}
\value{
data frame
}
\description{
Transform Time Series List to Data Frame
}
\examples{

tsl <- tsl_simulate(
  n = 3,
  rows = 10,
  time_range = c(
    "2010-01-01",
    "2020-01-01"
  ),
  irregular = FALSE
)

df <- tsl_to_df(
  tsl = tsl
)

names(df)
nrow(df)
head(df)
}
\seealso{
Other tsl_management: 
\code{\link{tsl_burst}()},
\code{\link{tsl_colnames_clean}()},
\code{\link{tsl_colnames_get}()},
\code{\link{tsl_colnames_prefix}()},
\code{\link{tsl_colnames_set}()},
\code{\link{tsl_colnames_suffix}()},
\code{\link{tsl_count_NA}()},
\code{\link{tsl_diagnose}()},
\code{\link{tsl_handle_NA}()},
\code{\link{tsl_join}()},
\code{\link{tsl_names_clean}()},
\code{\link{tsl_names_get}()},
\code{\link{tsl_names_set}()},
\code{\link{tsl_names_test}()},
\code{\link{tsl_ncol}()},
\code{\link{tsl_nrow}()},
\code{\link{tsl_repair}()},
\code{\link{tsl_subset}()},
\code{\link{tsl_time}()}
}
\concept{tsl_management}
