% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_as_time.R
\name{utils_as_time}
\alias{utils_as_time}
\title{Ensures Correct Class for Time Arguments}
\usage{
utils_as_time(x = NULL, to_class = NULL)
}
\arguments{
\item{x}{(required, vector) Vectors of the classes 'numeric', 'Date', and 'POSIXct' are valid and returned without any transformation. Character vectors are analyzed to determine their more probable type, and are coerced to 'Date' or 'POSIXct' depending on their number of elements. Generally, any character vector representing an ISO 8601 standard, like "YYYY-MM-DD" or "YYYY-MM-DD HH:MM:SS" will be converted to a valid class. If a character vector cannot be coerced to date, it is returned as is. Default: NULL}

\item{to_class}{(optional, class) Options are: NULL, "numeric", "Date", and "POSIXct". If NULL, 'x' is returned as the most appropriate time class. Otherwise, 'x' is coerced to the given class. Default: NULL}
}
\value{
time vector
}
\description{
This function guesses the class of a vector based on its elements. It can handle numeric vectors, character vectors that can be coerced to either "Date" or "POSIXct" classes, and vectors already in "Date" or "POSIXct" classes.
}
\examples{
# numeric
utils_as_time(
  x = c(-123120, 1200)
  )

# character string to Date
utils_as_time(
  x = c("2022-03-17", "2024-02-05")
  )

# incomplete character strings to Date
utils_as_time(
  x = c("2022", "2024")
  )

utils_as_time(
  x = c("2022-02", "2024-03")
  )

# character string to POSIXct
utils_as_time(
  x = c("2022-03-17 12:30:45", "2024-02-05 11:15:45")
  )

# Date vector (returns the input)
utils_as_time(
  x = as.Date(c("2022-03-17", "2024-02-05"))
  )

# POSIXct vector (returns the input)
utils_as_time(
  x = as.POSIXct(c("2022-03-17 12:30:45", "2024-02-05 11:15:45"))
  )

}
\seealso{
Other internal_time_handling: 
\code{\link{utils_coerce_time_class}()},
\code{\link{utils_is_time}()},
\code{\link{utils_new_time}()},
\code{\link{utils_time_keywords}()},
\code{\link{utils_time_keywords_dictionary}()},
\code{\link{utils_time_keywords_translate}()},
\code{\link{utils_time_units}()}
}
\concept{internal_time_handling}
