% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_weights.R
\name{aggregate_weights}
\alias{aggregate_weights}
\title{Aggregate discrete values}
\usage{
aggregate_weights(y, weights, sum_to_one = FALSE)
}
\arguments{
\item{y}{Vector of outcomes.}

\item{weights}{Vector of weights, one for each of \code{y}.
These need not sum to one, but must not be negative and non-NA.}

\item{sum_to_one}{Logical; should the weights be normalized
to sum to 1? Default is FALSE.}
}
\value{
Data frame with the following columns:
\itemize{
\item \code{y}: Increasing vector of unique values of \code{y} that have positive weight.
\item \code{weight}: Weights corresponding to each outcome.
}
}
\description{
Aggregates discrete values together with their weights
into a data frame or tibble.
}
\details{
For a vector of outcomes \code{y} with a matching vector of \code{weights},
\code{aggregate_weights()} provides a single non-zero, non-NA
weight per unique value of \code{y}.
}
\keyword{internal}
