% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_rac.R
\name{fit_rac}
\alias{fit_rac}
\alias{fit_rac.numeric}
\alias{fit_rac.species_distribution}
\title{Fit a distribution}
\usage{
fit_rac(x, ...)

\method{fit_rac}{numeric}(
  x,
  distribution = c("lnorm", "lseries", "geom", "bstick"),
  ...,
  check_arguments = TRUE
)

\method{fit_rac}{species_distribution}(
  x,
  distribution = c("lnorm", "lseries", "geom", "bstick"),
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object}

\item{...}{Unused.}

\item{distribution}{The distribution of species abundances.
May be "lnorm" (log-normal), "lseries" (log-series), "geom" (geometric) or
"bstick" (broken stick).}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A tibble with the sites and the estimated distribution parameters.
}
\description{
Fit a well-known distribution to a species distribution.
}
\details{
\link{abundances} can be used to fit rank-abundance curves (RAC) of classical
distributions:
\itemize{
\item "lnorm" for log-normal \insertCite{Preston1948}{divent}.
\item "lseries" for log-series \insertCite{Fisher1943}{divent}.
\item "geom" for geometric \insertCite{Motomura1932}{divent}.
\item "bstick" for broken stick \insertCite{MacArthur1957}{divent}.
It has no parameter, so the maximum abundance is returned.
}
}
\examples{
fit_rac(paracou_6_abd, distribution = "lnorm")

}
\references{
\insertAllCited{}
}
