#' Build the state covariance matrix for Predictive Dynamic Linear Models (pdlm)
#'
#'
#' @param x model parameters
#' @param k the dimension of observation equation
#' @param lags a nonnegative integer indicating the number of lags in latent state.
#'
#' @return A matrix with proper dimension.
#'
#' @noRd
#'
getW <- function(x, k, lags){
  W <- c(10**-8, c(x[1], rep(10**-8, lags)))
  if(length(x) == 2){
    W <- c(W, rep( c(x[-1], rep(10**-8, lags) ), k-1) )
  }else{
    W <- c(W, as.vector(rbind(x[-1],  matrix(10**-8, nrow=lags, ncol=length(x) - 1)) ))
  }

  W <- diag(W)
  return(W)
}
