% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramVertexOnlyGroup.R
\name{paramVertexOnlyGroup}
\alias{paramVertexOnlyGroup}
\title{Parameter estimation for Vertex model only for a list of dynamic networks.}
\usage{
paramVertexOnlyGroup(
  InputNetwork,
  VertexStatsvec = rep(1, nvertexstats),
  maxLag,
  VertexModelGroup = NA,
  VertexLag = rep(1, maxLag),
  VertexAttLag = rep(1, maxLag),
  VertexLagMatrix = matrix(1, maxLag, length(VertexStatsvec)),
  regMethod = "bayesglm"
)
}
\arguments{
\item{InputNetwork}{Input network list.}

\item{VertexStatsvec}{Binary vector of size 9, indicating vertex model.}

\item{maxLag}{maximum lag.}

\item{VertexModelGroup}{Group term for vertex model.}

\item{VertexLag}{Binary vector of size maxLag, indicating Lag terms in the model.}

\item{VertexAttLag}{Vertex group term lag vector.}

\item{VertexLagMatrix}{Binary matrix indicating lagged vertex statistics in
the model.}

\item{regMethod}{one of "glm", "glmnet", "bayesglm"}
}
\value{
List of 3 elements:\cr
VertexFit: Output from regEngine. \cr
VertexStats: Subsetted vertex stats matrix. \cr
VertexStatsFull: Full matrix of vertex stats.
}
\description{
Parameter estimation for Vertex model only for a list of dynamic networks.
}
\examples{
nvertexstats <- 9
InputNetwork <- beach
maxLag <- 3
VertexStatsvec <- rep(1, nvertexstats)
VertexLag <- rep(1, maxLag)
regMethod <- "bayesglm"
VertexModelGroup <- "regular"
VertexLagMatrix <- matrix(0, maxLag, nvertexstats)
VertexLagMatrix[, c(4, 7)] <- 1
VertexLagMatrix[c(2,3),7] <- 0
Vout1 <- paramVertexOnlyGroup(InputNetwork = beach,
                          maxLag = maxLag,
                          VertexStatsvec = VertexStatsvec,
                          VertexModelGroup = VertexModelGroup,
                          VertexLag = VertexLag,
                          VertexLagMatrix = VertexLagMatrix)
summary(Vout1$VertexFit$fit)
}
\author{
Abhirup
}
