% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchTop.R
\name{fetchTop}
\alias{fetchTop}
\title{Fetch Top Barcodes by Maximum Frequency}
\usage{
fetchTop(reshaped_df, N_LINEAGES)
}
\arguments{
\item{reshaped_df}{A dataframe returned by \code{reshapeData()}. Only the first
four columns are used.}

\item{N_LINEAGES}{An integer specifying the number of barcodes to retrieve.}
}
\value{
A dataframe containing the top \code{N_LINEAGES}. Used for selecting
dominant lineages for plotting or analysis.
}
\description{
This function retrieves the top \code{N_LINEAGES} barcodes from a reshaped dataframe,
as returned by \code{reshapeData()}. The top barcodes are assumed to be located in the
first \code{N_LINEAGES} rows of the reshaped dataframe. This implies that \code{reshaped_df}
should already be sorted by descending maximum frequency for correct behavior.
}
\examples{
# Load demo barcode count data (installed with the package)
demo_file <- system.file("extdata", "demo_input.csv", package = "doblin")
input_dataframe <- readr::read_csv(demo_file, show_col_types = FALSE)

# Reshape & sort the data
reshaped_df <- reshapeData(input_dataframe)

# Fetch the top 10 most abundant barcodes
top_barcodes <- fetchTop(reshaped_df, N_LINEAGES = 10)
}
