% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchDocket.r
\name{getBatchDictionary}
\alias{getBatchDictionary}
\title{Dictionary for multiple docket outputs}
\usage{
getBatchDictionary(
  filename,
  outputFiles,
  dictionaryLength = length(outputFiles)
)
}
\arguments{
\item{filename}{The file path to the document template}

\item{outputFiles}{A list of the file names and paths for the populated templates}

\item{dictionaryLength}{Number of columns in the batch dictionary. Defaults to the number of output files. Cannot be shorter than the count of 'outputFiles'}
}
\value{
Data frame for populating data into the template with row 1 containing the output file names
}
\description{
Scans the input file for strings enclosed by flag wings: « ». Creates a replacement value column for each document to be generated
}
\examples{
# Path to the sample template file included in the package
template_path <- system.file("batch_document", "batchTemplate.docx", package="docket")
temp_dir <- normalizePath(tempdir(), winslash = "/")
output_paths <- as.list(paste0(temp_dir, paste0("/batch document", 1:5, ".docx")))

# Create a dictionary by using the getDictionary function on the sample template file
result <- getBatchDictionary(template_path, output_paths)
print(result)
}
