% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doremi.R
\name{calculate.glla}
\alias{calculate.glla}
\title{Calculation of derivatives using the GLLA method}
\usage{
calculate.glla(signal, time, embedding = 3, n = 2)
}
\arguments{
\item{signal}{is the input vector containing the data from which the derivatives are estimated.}

\item{time}{is a vector containing the time values corresponding to the signal. Arguments signal and time must have the same length.}

\item{embedding}{is an integer indicating the embedding dimension, that is the number of points to consider for derivative calculation.
Embedding must be at least #' 2 for the calculation of the first derivative (first order models) and at least 3 for the calculation of
the second derivative (second order models).}

\item{n}{is the maximum order of the derivative to calculate}
}
\value{
Returns a list containing three columns:

dtime- contains the time values in which the derivative was calculated. That is, the moving average of the input time over embedding points.

dsignal- is a data.frame containing n+1 columns and the same number of rows as the signal.
The column k is the k-1 order derivative of the signal over embedding points.

embedding- number of points used for the derivative calculation.

n - the maximum derivative order calculated n
}
\description{
\code{calculate.glla} estimates the derivatives of a variable using the Generalized Local Linear Approximation (GLLA) method
described in \doi{10.4324/9780203864746}{Boker et al.(2010)}.
This method estimates the derivatives over a number of measurement points called the embedding number assuming an equally spaced time series.
}
\examples{
#In the following example the derivatives for the function y(t) = t^2 are calculated.
#The expected results are:
#y'(t) = 2t and y''(t) = 2
time <- c(1:500)/100
signal <- time^2
result <- calculate.glla(signal = signal, time = time, embedding = 5)

}
\keyword{derivative}
\keyword{embedding-number}
