% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers.R
\name{replace_numbers}
\alias{replace_numbers}
\title{Replace English number phrases with their decimal representations}
\usage{
replace_numbers(string)
}
\arguments{
\item{string}{A character vector. Can contain numbers and other text}
}
\value{
A character vector the same length as \code{string}, with words
replaced by their decimal representations.
}
\description{
Uses \code{\link{numb_replacements}} to match parts of a string corresponding
to numbers, then invokes \code{\link{words2number}} to convert these
substrings to numeric. The rest of the string (the non-number words) is
left intact.
}
\details{
Works on non-negative integer numbers under one billion
(one thousand million). Does not support fractions or decimals (yet).
}
\examples{
replace_numbers('Two plus two equals four')
replace_numbers('one hundred thousand dollars!')
replace_numbers(c('A vector', 'containing numbers', 'like thirty seven'))

}
\seealso{
\code{\link{words2number}}, for use on cleaned text that does not contain
any non-number words
}
