% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.dosresmeta}
\alias{print.dosresmeta}
\alias{summary.dosresmeta}
\alias{print.summary.dosresmeta}
\title{Summarizing dosresmeta Models}
\usage{
\method{print}{dosresmeta}(x, digits = 4, ...)

\method{summary}{dosresmeta}(object, ci.level = 0.95, ...)

\method{print}{summary.dosresmeta}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{an object of class \code{dosresmeta} or \code{summary.dosresmeta} produced by \code{\link{dosresmeta}} or \code{summary.dosresmeta}, respectively.}

\item{digits}{an integer specifying the number of digits to which printed results must be rounded.}

\item{\dots}{further arguments passed to or from other methods.}

\item{object}{an object of class \code{dosresmeta} produced by \code{\link{dosresmeta}}.}

\item{ci.level}{the confidence level used for defining the confidence intervals for the estimates of the (fixed-effects) coefficients.}

\item{signif.stars}{logical. If TRUE, 'significance stars' are printed for each coefficient.}
}
\value{
The \code{summary} method function for \code{dosresmeta} objects produces a list of class "\code{summary.dosresmeta}".
The components of the lists are some of those stored in the related \code{dosresmeta} object, plus the following:
\tabular{ll}{ 
\code{AIC} \tab the value of the Akaike information criterion for the fitted \code{dosresmeta} model, obtained through a call to \code{\link{AIC}}. \cr 
\code{BIC} \tab the value of the Bayesian information criterion for the fitted \code{dosresmeta} model, obtained through a call to \code{\link{BIC}} \cr
\code{corFixed} \tab the \eqn{p \times p}{p x p} correlation matrix of the fixed-effects coefficients, 
obtained from the (co)variance matrix \code{\link{vcov}} \cr
\code{corRandom} \tab the \eqn{p \times p}{p x p} correlation matrix of the random effects, obtained from the between-study (co)variance matrix \eqn{\Psi} \cr
\code{qstat} \tab results from the Cochran Q test for heterogeneity. \cr
\code{ci.level} \tab the confidence level used for defining the confidence intervals for the estimates of the fixed-effects coefficients. \cr
\code{chisq} \tab overall test similar to anova. \cr
}
As usual, the \code{print} method functions for classes "\code{dosresmeta}" and "\code{summary.dosresmeta}" do not return any value.
}
\description{
Print and summary method functions for dose-response models represented in objects of class "\code{dosresmeta}".
}
\details{
the \code{print} method for class \code{dosresmeta} only returns basic information of the fitted model, namely the call, 
estimated (fixed-effects) coefficients, dimensions, and fit statistics (log-likelihood, AIC, BIC).

The \code{summary} method function computes additional statistics and tests, and produces a list object of class \code{summary.dosresmeta}. 
The \code{print} method function for this class, depending on the number of studies included in the analysis, shows additional information, 
such as tables reporting the estimates for the fixed and random-effects parts of the model, Chi-square test for model significance, 
Cochran Q test for heterogeneity and I-square.
}
\examples{
## Load data and run the model
data("alcohol_cvd")
model <- dosresmeta(formula = logrr ~ dose + I(dose^2), type = type, id = id,
                    se = se, cases = cases, n = n, data = alcohol_cvd) 
## Defult print
model
## Specify digits
print(model, digit = 2)
## summary with 90th confidence intervals
summary(model, ci.level = .8)

}
\seealso{
\code{\link{dosresmeta}}, \code{\link{summary}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
