% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpseg.R
\docType{package}
\name{dpseg}
\alias{dpseg}
\alias{dpseg-package}
\title{dpseg : linear segmentation by dynamic programming}
\usage{
dpseg(x, y, maxl, jumps = FALSE, P = 0, minl = 3, S0 = 1,
  type = "var", scoref, verb = 1, move, store.values = TRUE,
  store.matrix = FALSE, add.lm = FALSE, recursion, backtrace, ...)
}
\arguments{
\item{x}{x-values, not used if \code{y} is a scoring function
matrix}

\item{y}{y-values, or a pre-calculated scoring function matrix
\eqn{SCR_{i,j}} (eg. from a previous run of \code{dpseg}). See
section "Value" below for details on the structure \eqn{SCR_{i,j}}.}

\item{maxl}{maximal segment length, \eqn{i\ge j-maxl}}

\item{jumps}{allow for jumps between segments, if \code{TRUE}
segment ends are 1 index left of the segment starts}

\item{P}{break-point penalty, increase to get longer segments with
lower scores (eg. higher residual variance)}

\item{minl}{minimal segment length, \eqn{i\le j-minl}}

\item{S0}{initialization of \eqn{S_0}, choose high enough to avoid
length 1 cutoffs at start}

\item{type}{type of scoring function: available are "var" for
"variance of residuals", "cor" for Pearson correlation, or "r2"
for r-squared; see the package \code{vignette("dpseg")} for
details.}

\item{scoref}{alternative scoring function}

\item{verb}{print progress messages}

\item{move}{logical indicating whether move is required in
backtracing, required for the alternative recursion \eqn{S_i +
score(i+1,j)}}

\item{store.values}{store scoring values (linear regression
results)}

\item{store.matrix}{store the fitscore matrix}

\item{add.lm}{add a linear fit using R base \code{lm} for final
segments; may save memory/speed if \code{store.values==FALSE}}

\item{recursion}{internal recursion function to be used for
segmentation; used for debugging, benchmarking and development,
and required for putative novel scoring functions \code{scoref}}

\item{backtrace}{internal function to be used for back-tracing;
used for debugging, benchmarking and development, and may be
required to test novel scoring functions \code{scoref} and/or
\code{recursion}}

\item{...}{further arguments to \code{recursion}}
}
\value{
Returns a list object of class \code{dpseg} (with
    \code{print.dpseg} \code{plot.dpseg} and \code{predict.dpseg}
    methods). The main result of the algorithm is a table
    (\code{data.frame}) of predicted segments in list object
    \code{segments}. The original data, run parameters and
    (optionally) additional data calculated and used by the
    algorithm are also returned.

\describe{

\item{segments:}{main result table: a \code{data.frame} that lists
    the start and end x-values of the segments, the start and end
    indices (i,j) in the data vectors, the linear regression
    coefficients and goodness-of-fit measures for the segments
    (intercept, slope, r-squared, variance of residuals). If
    \code{dpseg} was called with a pre-calculated scoring matrix,
    the table only contains start and end indices i,j. If option
    \code{add.lm=TRUE} or the result object was sent through
    function \code{\link{addLm}} the table additionally contains
    results from R's \code{lm}, indicated by an ".lm" suffix.}

\item{S:}{results of the recursion, ie. \eqn{S_j} in above
    equation.}

\item{imax:}{vector \eqn{j=1,\dots,n}, storing the \eqn{i_{max}}
    that yielded \eqn{S_j}, ie., the sole input for the backtracing
    function.}

\item{values:}{linear regression coefficients and measures for the
    segment ending at \eqn{j} and starting at
    \eqn{i_{max}(j)}. Only present if \code{store.valus=TRUE}.}


\item{SCR:}{scoring function matrix \eqn{SCR_{i,j} = score(i,j)}
    where positions j are the columns and i the rows; a banded
    matrix with non-NA values between \eqn{i\le j-minl} and
    \eqn{i\ge j-maxl}. Note, that this matrix can be re-used in
    subsequent calls as \code{dpseg(y=previous$SCR)} which runs
    much faster and allows to efficiently scan for alternative
    parameters. Only present if \code{store.matrix=TRUE}.}

\item{fits:}{result objects from \code{lm}. Only present if
    \code{add.lm=TRUE}.}

\item{traceback:}{result of the call to the backtracing function:
    ends of the segments.}

\item{xy:}{original x/y data (xy.coords).}

\item{removed:}{index of NA/Inf values that were removed before
    running the alorithm.}

\item{parameters:}{used parameters \code{P}, \code{jumps},
    \code{maxl} and \code{minl}.}
}
}
\description{
\code{dpseg} splits a curve (x,y data) into linear segments by a
straight forward dynamic programming recursion: \deqn{S_j =
max(S_{i-jumps} + score(i,j) -P)} where score is a measure of the
goodnes of the fit of a linear regression (equiv. to
\code{lm(y~x)}) between data points \eqn{i<j}. The default scoring
function is simply the negative variance of residuals of the linear
regression (see arguments \code{type} and \code{scoref}). \code{P}
is a break-point penality that implicitly regulates the number of
segments (higher P: longer segments), and \code{jumps==1} allows
for disjoint segments.  The arguments \code{minl} and \code{maxl}
specify minimal (\eqn{i\le j-minl}) and maximal (\eqn{i\ge j-maxl})
segment lengths, which allows to significantly decrease memory
usage when expected segment lengths are known.
}
\details{
See the \code{vignette("dpseg")} for the theory and details on the
choice of scoring functions and selection of the penalty parameter
P.
}
\section{Dependencies}{
 The package strictly depends only on \code{RcppEigen}.
All other dependencies are usually present in a
basic installation (\code{stats}, \code{graphics}, \code{grDevices}).
}

\examples{

## calculate linear segments in semi-log bacterial growth data
## NOTE: library loads bacterial growth curve data as data.frame oddata
segs <- dpseg(x=oddata$Time, y=log(oddata$A3), minl=5, P=0.0001, verb=1)

## inspect resulting segments
print(segs)

## plot results (also see the movie method)
plot(segs, delog=TRUE, log="y")

## predict method
plot(predict(segs), type="l")

}
\author{
Rainer Machne \email{machne@hhu.de}, Peter F. Stadler \email{studla@bioinf.uni-leipzig.de}
}
