% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic.R
\name{subtargets}
\alias{subtargets}
\title{List sub-targets \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}}
\usage{
subtargets(
  target = NULL,
  character_only = FALSE,
  cache = drake::drake_cache(path = path),
  path = NULL
)
}
\arguments{
\item{target}{Character string or symbol, depending on \code{character_only}.
Name of a dynamic target.}

\item{character_only}{Logical, whether \code{target} should be treated
as a character or a symbol.
Just like \code{character.only} in \code{\link[=library]{library()}}.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}
}
\value{
Character vector of sub-target names
}
\description{
List the sub-targets of a dynamic target.
}
\examples{
\dontrun{
isolate_example("dynamic branching", {
plan <- drake_plan(
  w = c("a", "a", "b", "b"),
  x = seq_len(4),
  y = target(x + 1, dynamic = map(x)),
  z = target(sum(x) + sum(y), dynamic = group(x, y, .by = w))
)
make(plan)
subtargets(y)
subtargets(z)
readd(x)
readd(y)
readd(z)
})
}
}
\seealso{
\code{\link[=get_trace]{get_trace()}}, \code{\link[=read_trace]{read_trace()}}
}
