% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtlcor_sim.R
\name{dtl_app_sim_single}
\alias{dtl_app_sim_single}
\title{Simulate a single drop-the-losers (DTL) trial.}
\usage{
dtl_app_sim_single(
  D,
  N,
  n,
  mPFS,
  q,
  gamma,
  drop_rate,
  enroll,
  interim_t,
  sel_g_func = sel_g_func_default,
  ...
)
}
\arguments{
\item{D}{Total number of events.}

\item{N}{Total number of patients in both selected and control arms
at final analysis.}

\item{n}{Number of patients per treatment arm at the DTL look.}

\item{mPFS}{A 3-entry vector of median progression-free survival times
for control, low dose and high dose arms (assume
exponential time-to-event outcome for all arms and the
conditional distribution for responders and non-responders
can be uniquely identified given q and gamma).}

\item{q}{A 3-entry vector of response rates under the null.}

\item{gamma}{Hazards ratio of responders and non-responders.}

\item{drop_rate}{Annual drop-out rate.}

\item{enroll}{Annual Enrollment rate.}

\item{interim_t}{A vector of information fractions of final stage.}

\item{sel_g_func}{Arm-select function. The default function is
sel_g_func_default(W_2, W_1, delta). Users can define
their own arm-select function. The format of
the function must be function_name(W_2, W_1, ...). The
return values must be 1 (arm 1 is selected) or 2 (arm 2
is selected) or 0 (stop for futility).}

\item{...}{Other arguments from sel_g_func.}
}
\value{
A list including (1) a data frame of response rates of low dose and
high dose W_1, W_2 and the log-rank test statistics Z_jk at kth interim
analysis if the jth arm is selected at DTL look; (2) data frames of
simulated data at DTL look; (3) data frames of simulated data at
interim or final analyses.
}
\description{
Simulate a single trial based on the DTL design
}
\examples{
# Inputs
set.seed(1000)
D           = 162
N           = 152  
n           = 80    
mPFS        = c(180, 276, 300)
q           = c(0.2, 0.4, 0.5)
gamma       = 0.15
drop_rate   = 0.05
enroll      = 20 * 12
interim_t   = c(0.5, 1)
delta       = 0.05  

# Run function
dtl_app_sim_single(D, N, n, mPFS, q, gamma, drop_rate, enroll, interim_t, delta = delta)
                  
}
