% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtlcor_fun.R
\name{dtl_sim_stat}
\alias{dtl_sim_stat}
\title{Generate normal approximated test statistics for drop-the-losers (DTL) design}
\usage{
dtl_sim_stat(nsim, n, q, t, rho)
}
\arguments{
\item{nsim}{Number of replicates}

\item{n}{Sample size per arm at DTL look}

\item{q}{Response rate under the null}

\item{t}{A vector of information fraction of final stage}

\item{rho}{Fixed correlation coefficient}
}
\value{
Data frame of the simulated test statistics
}
\description{
Generate normal approximated test statistics for drop-the-losers (DTL) design
}
\examples{
\donttest{
dtl_sim_stat(nsim = 1000, n = 80, q = 0.3, t = c(0.3, 1), rho = c(0.5, 0.3))
}

}
