% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtlcor_fun.R
\name{sel_g_func_default}
\alias{sel_g_func_default}
\title{Default arm-select function}
\usage{
sel_g_func_default(W_2, W_1, delta)
}
\arguments{
\item{W_2}{Response rate for arm 2 (high dose)}

\item{W_1}{Response rate for arm 1 (low dose)}

\item{delta}{Least difference to decide superiority of arm 2 (high dose)}
}
\value{
The function is \eqn{g(W_2, W_1; \Delta) = 
2I(W_2 - W_1 - \Delta > 0) + I(W_2 - W_1 - \Delta \leq 0)}.
It returns the following values:
1: arm 1 (low dose) is selected;
2: arm 2 (high dose) is selected.
}
\description{
Default arm-select function for selecting arm to the next stage.
}
\examples{
sel_g_func_default(W_2 = 0.5, W_1 = 0.3, delta = 0.05)

}
