% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dtw.R
\name{dtwPlotThreeWay}
\alias{dtwPlotThreeWay}
\title{Plotting of dynamic time warp results: annotated warping function}
\usage{
dtwPlotThreeWay(
  d,
  xts = NULL,
  yts = NULL,
  type.align = "l",
  type.ts = "l",
  match.indices = NULL,
  margin = 4,
  inner.margin = 0.2,
  title.margin = 1.5,
  xlab = "Query index",
  ylab = "Reference index",
  main = "Timeseries alignment",
  ...
)
}
\arguments{
\item{d}{an alignment result, object of class \code{dtw}}

\item{xts}{query vector}

\item{yts}{reference vector}

\item{type.align}{line style for warping curve plot}

\item{type.ts}{line style for timeseries plot}

\item{match.indices}{indices for which to draw a visual guide}

\item{margin}{outer figure margin}

\item{inner.margin}{inner figure margin}

\item{title.margin}{space on the top of figure}

\item{xlab}{label for the query axis}

\item{ylab}{label for the reference axis}

\item{main}{main title}

\item{...}{additional arguments, used for the warping curve}
}
\description{
Display the query and reference time series and their warping curve,
arranged for visual inspection.
}
\details{
The query time series is plotted in the bottom panel, with indices growing
rightwards and values upwards. Reference is in the left panel, indices
growing upwards and values leftwards. The warping curve panel matches
indices, and therefore element (1,1) will be at the lower left, (N,M) at the
upper right.

Argument \code{match.indices} is used to draw a visual guide to matches; if
a vector is given, guides are drawn for the corresponding indices in the
warping curve (match lines). If integer, it is used as the number of guides
to be plotted. The corresponding style is customized via the
\code{match.col} and \code{match.lty} arguments.

If \code{xts} and \code{yts} are not supplied, they will be recovered from
\code{d}, as long as it was created with the two-argument call of
\code{\link[=dtw]{dtw()}} with \code{keep.internals=TRUE}.  Only single-variate time
series can be plotted.
}
\section{Warning}{
 The function is incompatible with mechanisms for arranging
plots on a device: \code{par(mfrow)}, \code{layout} and \code{split.screen}.
Appearance of the match lines and timeseries currently can not be
customized.
}

\examples{


## A noisy sine wave as query
## A cosine is for reference; sin and cos are offset by 25 samples

idx<-seq(0,6.28,len=100);
query<-sin(idx)+runif(100)/10;
reference<-cos(idx)
dtw(query,reference,keep=TRUE)->alignment;


## Beware of the reference's y axis, may be confusing
## Equivalent to plot(alignment,type="three");
dtwPlotThreeWay(alignment);


## Highlight matches of chosen QUERY indices. We will do some index
## arithmetics to recover the corresponding indices along the warping
## curve

hq <- (0:8)/8              
hq <- round(hq*100)      #  indices in query for  pi/4 .. 7/4 pi

hw <- (alignment$index1 \%in\% hq)   # where are they on the w. curve?
hi <- (1:length(alignment$index1))[hw];   # get the indices of TRUE elems

dtwPlotThreeWay(alignment,match.indices=hi);

}
\seealso{
Other plot: 
\code{\link{dtwPlotDensity}()},
\code{\link{dtwPlotTwoWay}()},
\code{\link{dtwPlot}()}
}
\author{
Toni Giorgino
}
\concept{plot}
\keyword{hplot}
