% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynafluxr.R
\name{cli}
\alias{cli}
\title{Function to be called from shell command line}
\usage{
cli(args = commandArgs(trailingOnly = TRUE))
}
\arguments{
\item{args}{Character vector, command line parameters (default
\code{commandArgs(trailingOnly=TRUE)})}
}
\value{
a list resulting from \code{fdyn()} call
}
\description{
Function to be called from shell command line
}
\details{
run \code{cli("-h")} in R or \code{Rscript -e 'dynafluxr::cli()' -h}
  in shell to get a help page with available option description
}
\examples{
  # from shell
  # $ Rscript --vanilla -e 'dynafluxr::cli()' -m data_kinetics.tsv -s glycolysis.txt

  # from R session
  ddir=system.file("dataglyco", package="dynafluxr")
  meas=file.path(ddir, "data.tsv")
  sto=file.path(ddir, "network.txt")
  res=cli(c("-m", meas, "-s", sto, "--skip", "24", "-o", ""))
  tp=res$tp
  np=length(tp)
  tpp=res$tpp
  # plot species
  matplot(tpp, res$msp(tpp), type="l")
  matpoints(tp, res$mf[,-1], pch=".", cex=0.5)
  legend("topright", legend=colnames(bsppar(res$msp)$qw), lty=1:5, col=1:6, cex=0.75)
  # plot rates
  dev.new()
  matplot(tpp, res$vsp(tpp), type="l")
  # plot residuals
  dev.new()
  matplot(tpp, res$risp(tpp), type="l")
  legend("topright", legend=colnames(bsppar(res$rsp)$qw), lty=1:5, col=1:6, cex=0.75)
}
\seealso{
fdyn
}
