% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCV.R
\name{sampleCV}
\alias{sampleCV}
\title{Create Subsample of a Simulated Cyclic Voltammogram}
\usage{
sampleCV(filename, data.reduction = 1)
}
\arguments{
\item{filename}{The filename that contains the result of a simulated cyclic voltammetry experiment (created using the \code{cvSim} function).}

\item{data.reduction}{A value that gives the percentage of the original data to keep, which then is spaced evenly across the full data set.}
}
\value{
Returns a list with the following components \item{expt}{type of experiment; CV for a cyclic voltammetry simulation} \item{file_type}{value that indicates whether the output includes all data (full) or a subset of data (reduced); defaults to reduced} \item{current}{vector giving the current as a function of time} \item{potential}{vector giving the potential as a function of time}
}
\description{
Used to create a reduced data file of potentials and currents for a cyclic voltammogram or a linear sweep voltammogram. When passed to plotCV, the resulting plot shows the data as discrete points instead of as a line.
}
\examples{
ex_cv = simulateCV(e.start = 0.25, e.switch = -0.25, e.form = 0,
  x.units = 100, t.units = 1000)
ex_cvsample = sampleCV(ex_cv, data.reduction = 5)
str(ex_cvsample)
}
