% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_labels.R
\name{add_labels}
\alias{add_labels}
\title{Add labels to a plotly scatter plot}
\usage{
add_labels(p, labs, plotGlPixelRatio = 8)
}
\arguments{
\item{p}{A plotly scatter plot object}

\item{labs}{Character vector of labels to match}

\item{plotGlPixelRatio}{Integer passed to plotly.js config which controls
pixel resolution of webGl rendering. Larger values increase resolution of
points as well as file size.}
}
\value{
A plotly plot with added labels
}
\description{
Adds labels to a plotly 2d or 3d scatter plot. The labels can be dragged.
}
\details{
Labels are identified by searching the rownames of the embedded marker data
within the plotly object. The plotly mode bar camera icon is set to export to
svg by default.
}
\examples{
library(plotly)
data(mtcars)

p <- plot_ly(mtcars, x = ~mpg, y = ~wt, color = ~cyl,
             type = 'scatter', mode = 'markers')
p \%>\% add_labels(c("Mazda RX4", "Fiat 128"))
}
