% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tourism_quarterly}
\alias{tourism_quarterly}
\title{Quarterly Tourism Trips by Region and Purpose}
\format{
A data frame with `r nrow(tourism_quarterly)` rows and 4 variables:
* **year**: The year of the tourism data
* **quarter**: Quarter number like 1, 2, 3, 4
* **purpose**: Purpose of visit category:
  - `"Holiday"`
  - `"Business"`
* **trips**: Number of overnight trips (in thousands).
* **region_id**: Unique integer identifier linking to the
  \code{\link{tourism_region}} dataset.
  * **ws_id**: Identifier of the nearest Bureau of Meteorology weather station
  to the tourism region.
}
\usage{
tourism_quarterly
}
\description{
A dataset containing quarterly estimates of overnight tourism trips
in Australia, broken down by trip purpose and tourism region.
}
\details{
Tourism regions are formed through the aggregation of Statistical
Local Areas (SLAs) or similar ABS-defined geographies, as determined
by state and territory tourism authorities. This dataset is designed
for analysis of seasonal tourism patterns and can be joined to
\code{\link{tourism_region}} for spatial analysis.
}
\examples{
data(tourism_quarterly)
head(tourism_quarterly)
}
\references{
Tourism Research Australia: \url{https://www.tra.gov.au}
}
\keyword{datasets}
