% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariables.R
\name{getVariables}
\alias{getVariables}
\title{Get variables}
\usage{
getVariables(
  source = "TerraClimate",
  vars = varsAvailable(source)$vars,
  years = varsAvailable(source)$years,
  region = c(-180, 180, -90, 90),
  file = NULL,
  verbosity = 2
)
}
\arguments{
\item{source}{source to import the raster variables from, e.g. "TerraClimate" (currently the only one implemented)}

\item{vars}{character vector of the names of the variables to be imported. Run varsAvailable() for options. The default is to download all available variables from the specified 'source'. Note that the download can take a long time, especially for many variables, long series of years, and/or large regions.}

\item{years}{year range to get the variables from (e.g. 1979:2013). Note that the download can take a long time for long series of years.}

\item{region}{optional length-four numeric vector (xmin, xmax, ymin, ymax geodetic coordinates in degrees), SpatExtent or SpatVector polygon delimiting the region of the world for which the variables should be downloaded. See e.g. fuzzySim::getRegion() for suggestions. The larger the region, the longer the download time.}

\item{file}{optional file name (including the path, not including the filename extension) if you want the downloaded variable rasters to be saved on disk, in which case they are saved as a compressed multi-layer GeoTIFF. If 'file' already exists in the working directory, variables are imported from there.}

\item{verbosity}{integer value indicating the amount of messages to display. The default is 2, for the maximum number of messages available.}
}
\value{
multi-layer SpatRaster
}
\description{
This function downloads a specified time series of variables from a specified environmental data source, optionally (to save download time) within a specified region. Currently "TerraClimate" (Abatzoglou et al., 2018) is the only implemented data source.
}
\examples{
\donttest{
if (interactive()) {

# note these downloads may take long!

vars <- ecotrends::getVariables(vars = c("tmin", "tmax", "ppt", "pet", "ws"),
years = 1981:1990, region = terra::ext(-11, -4, 37, 45), file = paste0(tempdir(), "/variables"))

# tempdir() is here to comply with CRAN policy, but you should normally
# use a directory that you can access again when reopening R
# to avoid downloading the variables again every time

names(vars)

terra::plot(vars[[1:6]])

}
}
}
\references{
Abatzoglou, J.T., S.Z. Dobrowski, S.A. Parks, K.C. Hegewisch (2018) Terraclimate, a high-resolution global dataset of monthly climate and climatic water balance from 1958-2015. Scientific Data, 5, Article number: 170191. doi: 10.1038/sdata.2017.191(2018). Database URL: https://www.climatologylab.org/terraclimate.html
}
\seealso{
\code{\link[=varsAvailable]{varsAvailable()}}
}
\author{
A. Marcia Barbosa
}
